<?php
require_once '/var/www/www.grooveguild.lol/doc/prototype/DAO/AlbumDAO.php';


try {
    $albums = AlbumDAO::getAllAlbums();
} catch (Exception $e) {
    die("Erreur lors de la récupération des albums : " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Groove Guild – Liste des albums</title>
<link rel="stylesheet" href="css/liste.css" />
</head>
<body>
  <header>
    <?php include "/var/www/www.grooveguild.lol/doc/prototype/navbar/nav-bar.html"; ?>
  </header>

<main class="container">
  <section class="panel">
    
    <?php foreach ($albums as $album): ?>
      <article class="album">
        <h3 class="album-title"><?= htmlspecialchars($album["titre"]) ?></h3>
        
        <div class="controls">
          <?php if (!empty($album["extrait"])): ?>
            <audio controls>
              <source src="/doc/prototype/<?= htmlspecialchars($album["extrait"]) ?>" type="audio/mpeg">
              Votre navigateur ne supporte pas l’audio.
            </audio>
          <?php else: ?>
            <button class="btn" type="button">Échantillon non disponible</button>
          <?php endif; ?>
        </div>
        
        <p class="album-desc">
          Auteur: <?= htmlspecialchars($album["auteur"]) ?><br>
        </p>
        
        <?php if (!empty($album["image"])): ?>
          <div class="picture">
              <img src="/doc/<?= htmlspecialchars($album["image"]) ?>" alt="Image de l'album">
          </div>

          <div class="duration">Durée: <?= htmlspecialchars($album["duree"]) ?></div>

          <div class="tags">
                    <?php foreach ($album["tags"] as $tag): ?>
                        <span class="tag"><?= htmlspecialchars($tag["nom"]) ?></span>
                    <?php endforeach; ?>
                </div>

          <?php
                    $html = '<div class="rating" aria-label="Rate this article">' . PHP_EOL;
                    for ($i = 1; $i <= 5; $i++) {
                        if ($i <= $album["note"]) {
                            $html .= '    <span class="star filled">★</span>' . PHP_EOL;
                        } else {
                            $html .= '    <span class="star">★</span>' . PHP_EOL;
                        }
                    }
                    $html .= '</div>' . PHP_EOL;
                    echo $html
                ?>


        <?php endif; ?>
      
        
        <div class="details">
        <a href="/doc/prototype/detail/detail.php?id=<?= $album['id'] ?>" class="btn-details">Détail</a>
        </div>
      </article>
    <?php endforeach; ?>
  </section>
</main>
  <footer>
    <?php include "/var/www/www.grooveguild.lol/doc/prototype/footer/footer.html"; ?>
  </footer>
</body>
</html>
