<?php
session_start();
require_once '/var/www/html/doc/prototype/DAO/AlbumDAO.php';
require_once '/var/www/html/doc/prototype/modele/Album.php';
// When form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Handle uploaded files (image + audio)
   $baseDir       = "/var/www/html/doc/";
    $uploadDirImg  = $baseDir . "images/";
    $uploadDirAudio= $baseDir . "prototype/snippets/";

    if (!is_dir($uploadDirImg))  mkdir($uploadDirImg, 0777, true);
    if (!is_dir($uploadDirAudio)) mkdir($uploadDirAudio, 0777, true);

   $imagePath = null;
    $audioPath = null;

    if (!empty($_FILES['image']['name'])) {
        $imagePath = "images/" . basename($_FILES['image']['name']);
        move_uploaded_file($_FILES['image']['tmp_name'], $uploadDirImg . basename($_FILES['image']['name']));
    }

    if (!empty($_FILES['audio']['name'])) {
        $audioPath = "snippets/" . basename($_FILES['audio']['name']);
        move_uploaded_file($_FILES['audio']['tmp_name'], $uploadDirAudio . basename($_FILES['audio']['name']));
    }
    if (!empty($_FILES)) {
    echo "<pre>";
    print_r($_FILES);
    echo "</pre>";
}


    // Album non filtrer
    $brut = [
        'id'           => null,
        'titre'        => $_POST['titre'],
        'auteur'       => $_POST['auteur'],
        'date_sortie'  => $_POST['date']    ?? null,
        'duree'        => null, //ignorefornow
        'image'        => null, //ignorefornow
        'extrait'      => null, //ignorefornow
        'tags'         => $_POST['tags'],
        'note'         => isset($_POST['note']) ? (int)$_POST['note'] : null //ignorefornow,
    ];
    // filtrer
    $albumObj = new Album($brut);

    if ($albumObj->hasErreurs()) {
        $_SESSION['flash_errors'] = $albumObj->getErreurs();
        //$_SESSION['old'] = $_POST;
        header('Location: ' . $_SERVER['REQUEST_URI']); // retour sur la même page (GET)
        exit;
    }

    // preparer album filtrer
    $payloadDAO = [
        'titre'   => $albumObj->titre   ?? '',
        'image'   => $imagePath,
        'duree'   => null,
        'auteur'  => $albumObj->auteur  ?? '',
        'date'    => $_POST['date']    ?? null,
        'extrait' => $audioPath,
        'tags'    => $_POST['tags'] ?? '',
        'note'    => isset($_POST['note']) ? (int)$_POST['note'] : null,
    ];
    // Insert into DB
    AlbumDAO::addAlbum($payloadDAO);

    // Redirect or show success
    header("Location: ../administration/administration.php");
    exit;
}

?>
<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Groove Guild – Admin / Ajouter</title>
    <link rel="stylesheet" href="css/style-ajouter-admin.css">
</head>

<body>
<?php if (!empty($_SESSION['flash_errors'])): ?>
  <?php
    $errs = $_SESSION['flash_errors'];
    unset($_SESSION['flash_errors']);
    $lines = [];
    foreach ($errs as $field => $arr) {
      foreach ((array)$arr as $msg) { $lines[] = ucfirst($field) . ': ' . $msg; }
    }
    $alertMsg = json_encode(implode("\n", $lines), JSON_HEX_TAG|JSON_HEX_APOS|JSON_HEX_QUOT|JSON_HEX_AMP);
  ?>
  <script> alert(<?= $alertMsg ?>); </script>
<?php endif; ?>
 <header>
    <?php include "/var/www/html/doc/prototype/navbar/nav-bar.html"; ?>
  </header>
    <main class="wrap">
        <section class="panel">
            <h1>Ajouter</h1>
            <form action="#" method="post" enctype="multipart/form-data">
                <div class="field">
                    <label for="titre">Titre</label>
                    <input id="titre" name="titre" type="text" placeholder="Titre" required>
                </div>


                <div class="row-2">
                    <div class="field">
                        <label for="auteur">Auteur</label>
                        <input id="auteur" name="auteur" type="text" placeholder="Auteur">
                    </div>
                    <div class="field">
                        <label for="date">Date</label>
                        <input id="date" name="date" type="date">
                    </div>
                </div>


                <div class="row-2">
                    <div class="field">
                        <label for="genre">Tags</label>
                        <input id="tags" name="genre" type="text" placeholder="Ex. Rock, Indie, Jazz" value="rock">
                    </div>
                    <div class="field">
                        <label for="note">Note (1–5)</label>
                        <div class="range-wrap" style="display:flex;align-items:center;gap:12px;">
                            <input
                            type="range"
                            id="note"
                            name="note"
                            min="1"
                            max="5"
                            step="1"
                            value="3"
                            aria-label="Note entre 1 et 5">
                        </div>
                    </div>
                </div>

                <!-- Image dropzone -->

    <div class="field">
        <label>Image</label>
        <input id="image" name="image" type="file" accept="image/*">
    </div>

    <div class="field">
        <label>MP3</label>
        <input id="audio" name="audio" type="file" accept="audio/mpeg">
    </div>



                <div class="actions">
                    <button class="btn" type="submit">Ajouter</button>
                </div>
                <div class="actions">
                    <button class="btn" onclick="window.location.href='../administration/administration.php'">Annuler</button>
                </div>
            </form>
        </section>
    </main>
  <footer>
    <iframe src="../footer/footer.html" style="width:100%; border:none;" scrolling="no"></iframe>
  </footer>
</body>

</html>
