<?php
require_once '/var/www/html/doc/prototype/DAO/AlbumDAO.php';

try {
    $albums = AlbumDAO::getAllAlbums();
    $tags = AlbumDAO::getAllTags();
} catch (Exception $e) {
    die("Erreur lors de la récupération des albums : " . $e->getMessage());
}
try {
    $albums = AlbumDAO::getAllAlbums();
    $tags = AlbumDAO::getAllTags();
    $nbExtraits = AlbumDAO::countExtraits();
} catch (Exception $e) {
    die("Erreur lors de la récupération des albums : " . $e->getMessage());
}

?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Groove Guild – Administration</title>
  <link rel="stylesheet" href="css/administration.css" />
</head>
<body>
<header>
    <?php include "/var/www/html/doc/prototype/navbar/nav-bar.html"; ?>
</header>


<main class="container">

  <!-- Section Informations -->
  <section class="panel">
    <h2 class="panel-title">Informations :</h2>
    <div class="info-grid">
      <article class="info-card">
        <h3 class="info-title">Extraits :</h3>
        <ul class="stat-list">
<li class="stat-item"><span class="stat-text"><strong><?= htmlspecialchars($nbExtraits) ?></strong> Extraits</span></li>
        </ul>
      </article>
    </div>
  </section>

  <!-- Section Actions -->
  <section class="panel">
    <div class="cont">
      <h2 class="tier">Action :</h2>
      <h2 class="tier"><a href="../admin-ajout/admin-ajout.php" class="dwa ajouter">Ajouter</a></h2>
    </div>
  </section>

  <!-- Section Albums -->
  <section class="panel">
    <?php foreach ($albums as $album): ?>
      <article class="album">
        <h3 class="album-title"><?= htmlspecialchars($album["titre"]) ?></h3>
        
        <div class="controls">
          <?php if (!empty($album["extrait"])): ?>
            <audio controls>
              <source src="../<?= htmlspecialchars($album["extrait"]) ?>" type="audio/mpeg">
              Votre navigateur ne supporte pas l’audio.
            </audio>
          <?php else: ?>
            <button class="btn" type="button">Échantillon non disponible</button>
          <?php endif; ?>
        </div>

        <p class="album-desc">
          Auteur: <?= htmlspecialchars($album["auteur"]) ?><br>
          Sortie: <?= htmlspecialchars($album["date"]) ?>
        </p>

        <?php if (!empty($album["image"])): ?>
          <div class="picture">
            <img src="/doc/<?= htmlspecialchars($album["image"]) ?>" alt="Image de l'album">
          </div>
        <?php endif; ?>

        <div class="meta">
     
          <div class="duration">Durée: <?= htmlspecialchars($album["duree"]) ?></div>
          <div class="tags">
                    <?php foreach ($album["tags"] as $tag): ?>
                        <span class="tag"><?= htmlspecialchars($tag["nom"]) ?></span>
                    <?php endforeach; ?>
                </div>
          <div class="rating">
          <?php
                    $html = '<div class="rating" aria-label="Rate this article">' . PHP_EOL;
                    for ($i = 1; $i <= 5; $i++) {
                        if ($i <= $album["note"]) {
                            $html .= '    <span class="star filled">★</span>' . PHP_EOL;
                        } else {
                            $html .= '    <span class="star">★</span>' . PHP_EOL;
                        }
                    }
                    $html .= '</div>' . PHP_EOL;
                    echo $html
                ?>
               

        </div>

        

        <div class="detail">
          <a href="../detail/detail.php?id=<?= $album["id"] ?>" class="btn-detail">Détail</a>
          <a href="../admin-modif/admin-modif.php?id=<?= $album["id"] ?>" class="btn-detail">Modifier</a>
          <a href="supprimer.php?id=<?= $album["id"] ?>" class="btn-detail" onclick="return confirm('Supprimer cet album ?')">Supprimer</a>
        </div>
      </article>
    <?php endforeach; ?>
  </section>

  <footer>
    <iframe src="../footer/footer.html" style="width:100%; border:none;" scrolling="no"></iframe>
</footer>
</main>
</body>
</html>
