<?php

class Album
{
	public static $filtres =
		array(
			'id' => FILTER_VALIDATE_INT,
			'titre' => FILTER_SANITIZE_STRING,
			'auteur' => FILTER_SANITIZE_STRING,
			'date_sortie' => FILTER_UNSAFE_RAW,
			'duree' => FILTER_SANITIZE_STRING,
			'image' => FILTER_SANITIZE_URL,
            'extrait' => FILTER_SANITIZE_URL,
            'tags' => FILTER_SANITIZE_STRING,
            'note' => FILTER_VALIDATE_INT,
		);

	protected $id;
	protected $titre;
	protected $auteur;
	protected $date_sortie;
	protected $duree;
    protected $image;
	protected $extrait;
	protected $tags;
    protected $note;

	public function __construct($tableau)
	{
		$tableau = filter_var_array($tableau, Album::$filtres);

		$this->id = $tableau['id'];
		$this->titre = $tableau['titre'];
		$this->auteur = $tableau['auteur'];
        $this->date_sortie = $tableau['date_sortie'];
        $this->duree = $tableau['duree'];
        $this->image = $tableau['image'];
        $this->extrait = $tableau['extrait'];
        $this->tags = $tableau['tags'];
        $this->note = $tableau['note'];
	}

	public function __set($propriete, $valeur)
	{
		switch($propriete)
		{
			case 'id':
				$this->id = $valeur;
			break;
			case 'titre':
				$this->titre = $valeur;
			break;
			case 'auteur':
				$this->auteur = $valeur;
			break;
            case 'date_sortie':
				$this->date_sortie = $valeur;
			break;
            case 'duree':
				$this->duree = $valeur;
			break;
            case 'image':
				$this->image = $valeur;
			break;
            case 'extrait':
				$this->extrait = $valeur;
			break;
            case 'tags':
				$this->tags = $valeur;
			break;
            case 'note':
				$this->note = $valeur;
			break;
		}
	}

	public function __get($propriete)
	{
		//$variable = '$this->'.$propriete;
		//return $$variable;
		$self = get_object_vars($this); // externaliser pour optimiser
		//print_r($self);
		return $self[$propriete];
	}
}
//$contrat = new Contrat();
//$contrat->titre = "coucou";
//echo $contrat->titre;
?>
