<?php
require_once '/var/www/html/doc/prototype/DAO/AlbumDAO.php';
if (!isset($_GET['id'])) {
    die("Aucun album sélectionné.");
}
$id = (int)$_GET['id'];
try {
    $album = AlbumDAO::getSongById($id);
    if (!$album) {
        die("Album introuvable.");
    }
    // No need to split tags - they're already properly structured from the updated getSongById method
} catch (Exception $e) {
    die("Erreur lors de la récupération de l'album : " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Détail de l'album – Groove Guild</title>
  <link rel="stylesheet" href="../administration/css/administration.css" />
</head>
<body>
 <header>
    <?php include "/var/www/html/doc/prototype/navbar/nav-bar.html"; ?>
  </header>
<main class="container">
  <!-- Section Album -->
  <section class="panel">
    <article class="album">
      <h3 class="album-title"><?= htmlspecialchars($album["titre"]) ?></h3>
      <div class="controls">
        <?php if (!empty($album["extrait"])): ?>
          <audio controls>
            <source src="/doc/prototype/<?= htmlspecialchars($album["extrait"]) ?>" type="audio/mpeg">
            Votre navigateur ne supporte pas l'audio.
          </audio>
        <?php else: ?>
          <button class="btn" type="button">Échantillon non disponible</button>
        <?php endif; ?>
      </div>
      <p class="album-desc">
        Auteur: <?= htmlspecialchars($album["auteur"]) ?><br>
        Sortie: <?= htmlspecialchars($album["date"]) ?>
      </p>
      <?php if (!empty($album["image"])): ?>
        <div class="picture">
          <img src="/doc/<?= htmlspecialchars($album["image"]) ?>" alt="Image de l'album">
        </div>
      <?php endif; ?>
      <div class="meta">
        <div class="tags">
          Tags:
          <?php if (!empty($album["tags"])): ?>
            <?php foreach ($album["tags"] as $tag): ?>
              <span><?= htmlspecialchars($tag["nom"]) ?></span>
            <?php endforeach; ?>
          <?php else: ?>
            <span>Aucun tag</span>
          <?php endif; ?>
        </div>
        <div class="duration">Durée: <?= htmlspecialchars($album["duree"]) ?></div>
        <?php
                    $html = '<div class="rating" aria-label="Rate this article">' . PHP_EOL;
                    for ($i = 1; $i <= 5; $i++) {
                        if ($i <= $album["note"]) {
                            $html .= '    <span class="star filled">★</span>' . PHP_EOL;
                        } else {
                            $html .= '    <span class="star">★</span>' . PHP_EOL;
                        }
                    }
                    $html .= '</div>' . PHP_EOL;
                    echo $html
                ?>
      </div>
      <div class="detail">
        <a href="../liste/liste.php" class="btn-detail">← Retour</a>
      </div>
    </article>
  </section>
</main>
</body>
</html>
