<?php
require_once '/var/www/html/doc/prototype/DAO/AlbumDAO.php';


try {
    $albums = AlbumDAO::getAllAlbums();
    $tags = AlbumDAO::getAllTags();
    $recent_album = AlbumDAO::getRecentAlbums();

    if (count($albums) >= 3) {
        $randomKeys = array_rand($albums, 3);

        $randomAlbums = [
            $albums[$randomKeys[0]],
            $albums[$randomKeys[1]],
            $albums[$randomKeys[2]],
        ];
    } else {
        $randomAlbums = $albums;
    }
} catch (Exception $e) {
    die("Erreur lors de la récupération des albums : " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Groove Guild – Prototype</title>
  <link rel="stylesheet" href="css/style.css">
</head>
<body>
  <header>
    <?php include "/var/www/html/doc/prototype/navbar/nav-bar.html"; ?>
  </header>

  <main class="wrap" role="main">
    <section>
        <?php foreach ($randomAlbums as $album): ?>
            <article class="card album pad">
                <h3><?= htmlspecialchars($album["titre"]) ?></h3>
                <div class="controls">
                    <?php if (!empty($album["extrait"])): ?>
                        <audio controls>
                        <source src="/doc/prototype/<?= htmlspecialchars($album["extrait"]) ?>" type="audio/mpeg">
                            Votre navigateur ne supporte pas l’audio.
                        </audio>
                    <?php else: ?>
                        <button class="btn" type="button">Échantillon non disponible</button>
                    <?php endif; ?>
                </div>
                <p>
                    Auteur: <?= htmlspecialchars($album["auteur"]) ?><br>
                    Sortie: <?= htmlspecialchars($album["date"]) ?>
                </p>
                <?php if (!empty($album["image"])): ?>
                    <div class="picture">
                        <img src="/doc/<?= htmlspecialchars($album["image"]) ?>" alt="Image de l'album">
                    </div>
                <?php endif; ?>

                <div class="meta">
                <div class="tags">
                    <?php foreach ($album["tags"] as $tag): ?>
                        <span class="tag"><?= htmlspecialchars($tag["nom"]) ?></span>
                    <?php endforeach; ?>
                </div>
                <?php
                    $html = '<div class="rating" aria-label="Rate this article">' . PHP_EOL;
                    for ($i = 1; $i <= 5; $i++) {
                        if ($i <= $album["note"]) {
                            $html .= '    <span class="star filled">★</span>' . PHP_EOL;
                        } else {
                            $html .= '    <span class="star">★</span>' . PHP_EOL;
                        }
                    }
                    $html .= '</div>' . PHP_EOL;
                    echo $html
                ?>
            </article>
        <?php endforeach; ?>
    </section>

    <aside class="side">
      <section class="card">
        <h4>Latest Albums</h4>
        <?php foreach ($recent_album as $album): ?>
            <div class="item">
                <div class="album-thumbs">
                    <?php if (!empty($album["image"])): ?>
                            <div class="thumb">
                                <img src="/doc/<?= htmlspecialchars($album["image"]) ?>" alt="Image de l'album">
                            </div>   
                    <?php endif; ?>
                    
                    <div>
                        <div>
                            <strong><?= htmlspecialchars($album["titre"]) ?></strong>
                        </div>
                        <small>1 week ago</small>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
      </section>

      <section class="card">
        <h4>Tag Cloud</h4>
        <div class="tagcloud">
            <?php foreach ($tags as $tag): ?>
                <span class="tag"><?= htmlspecialchars($tag["tag"]) ?></span>
            <?php endforeach; ?>
        </div>
      </section>
      
    </aside>
  </main>

  <footer>
    <?php include "/var/www/html/doc/prototype/footer/footer.html"; ?>
  </footer>
</body>
</html>
