<?php
// AlbumDAO.php
//require_once '/var/www/www.grooveguild.lol/doc/prototype/DB/DB.php';
// Try prod first, fall back to dev if prod not available
$prod = '/var/www/www.grooveguild.lol/doc/prototype/DB/DB.php';
$dev  = '/var/www/www.dev.grooveguild.lol/doc/prototype/DB/DB.php';

if (file_exists($prod)) {
    require_once $prod;
} elseif (file_exists($dev)) {
    require_once $dev;
} else {
    die("Impossible de charger la configuration de la base de données (ni prod ni dev).");
}
class AlbumDAO {
    public static function getAllAlbums() {
        $pdo = Database::getConnection();

        $stmt = $pdo->query("
            SELECT a.id, a.titre, a.image, a.duree, a.auteur, a.date,
                a.extrait, a.note,
                t.id AS tag_id, t.tag AS tag_nom
            FROM albums a
            LEFT JOIN albums_tags at ON a.id = at.album_id
            LEFT JOIN tags t ON at.tag_id = t.id
            ORDER BY a.id
        ");

        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

        $albums = [];

        foreach ($rows as $row) {
            $id = $row['id'];

            if (!isset($albums[$id])) {
                $albums[$id] = [
                    'id'      => $row['id'],
                    'titre'   => $row['titre'],
                    'image'   => $row['image'],
                    'duree'   => $row['duree'],
                    'auteur'  => $row['auteur'],
                    'date'    => $row['date'],
                    'extrait' => $row['extrait'],
                    'note'    => $row['note'],
                    'tags'    => []
                ];
            }

            if ($row['tag_id'] !== null) {
                $albums[$id]['tags'][] = [
                    'id'  => $row['tag_id'],
                    'nom' => $row['tag_nom']
                ];
            }
        }

        return array_values($albums);
    }

    public static function countExtraits() {
     $pdo = Database::getConnection();
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM albums WHERE extrait IS NOT NULL AND extrait != ''");
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    return $row['total'];
}

    public static function getSongById($id) {
    $pdo = Database::getConnection();

    $stmt = $pdo->prepare("
        SELECT a.id, a.titre, a.image, a.duree, a.auteur, a.date,
            a.extrait, a.note,
            t.id AS tag_id, t.tag AS tag_nom
        FROM albums a
        LEFT JOIN albums_tags at ON a.id = at.album_id
        LEFT JOIN tags t ON at.tag_id = t.id
        WHERE a.id = ?
        ORDER BY a.id
    ");

    $stmt->execute([$id]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($rows)) {
        return false;
    }

    // Build the album with tags (same logic as getAllAlbums)
    $album = [
        'id'      => $rows[0]['id'],
        'titre'   => $rows[0]['titre'],
        'image'   => $rows[0]['image'],
        'duree'   => $rows[0]['duree'],
        'auteur'  => $rows[0]['auteur'],
        'date'    => $rows[0]['date'],
        'extrait' => $rows[0]['extrait'],
        'note'    => $rows[0]['note'],
        'tags'    => []
    ];

    foreach ($rows as $row) {
        if ($row['tag_id'] !== null) {
            $album['tags'][] = [
                'id'  => $row['tag_id'],
                'nom' => $row['tag_nom']
            ];
        }
    }

    return $album;
}

    public static function addAlbum(array $album){
        $pdo = Database::getConnection();

        $tags = isset($album['tags'])
            ? (is_array($album['tags']) ? implode(',', $album['tags']) : $album['tags'])
            : null;

       $sql = "INSERT INTO albums
            (titre, image, duree, auteur, date, extrait, note)
        VALUES
            (:titre, :image, :duree, :auteur, :date, :extrait, :note)";
$stmt = $pdo->prepare($sql);

$stmt->execute([
    ':titre'   => $album['titre']   ?? null,
    ':image'   => $album['image']   ?? null,
    ':duree'   => $album['duree']   ?? null,
    ':auteur'  => $album['auteur']  ?? null,
    ':date'    => $album['date']    ?? null,
    ':extrait' => $album['extrait'] ?? null,
    ':note'    => $album['note']    ?? null,
]);

$albumId = $pdo->lastInsertId();

// Insert tags into albums_tags
if (!empty($album['tags']) && is_array($album['tags'])) {
    $tagStmt = $pdo->prepare("INSERT INTO albums_tags (album_id, tag_id) VALUES (:album_id, :tag_id)");
    foreach ($album['tags'] as $tagId) {
        $tagStmt->execute([':album_id' => $albumId, ':tag_id' => $tagId]);
    }
}
    }


 public static function updateAlbum(int $id, array $album){
    $pdo = Database::getConnection();

    // Update the album main fields (no "tags" column in albums table!)
    $sql = "UPDATE albums
               SET titre   = :titre,
                   image   = :image,
                   duree   = :duree,
                   auteur  = :auteur,
                   date    = :date,
                   extrait = :extrait,
                   note    = :note
             WHERE id = :id";
    $stmt = $pdo->prepare($sql);

    $stmt->execute([
        ':id'      => $id,
        ':titre'   => $album['titre']   ?? null,
        ':image'   => $album['image']   ?? null,
        ':duree'   => $album['duree']   ?? null,
        ':auteur'  => $album['auteur']  ?? null,
        ':date'    => $album['date']    ?? null,
        ':extrait' => $album['extrait'] ?? null,
        ':note'    => $album['note']    ?? null,
    ]);

    echo "<script>console.log('PHP variable:', '" . $album['tags'] . " ');</script>";
    // Handle tags separately
    if (isset($album['tags']) && is_array($album['tags'])) {

        // Delete old tags
        $pdo->prepare("DELETE FROM albums_tags WHERE album_id = :album_id")
            ->execute([':album_id' => $id]);

        // Insert new tags
        $tagStmt = $pdo->prepare("INSERT INTO albums_tags (album_id, tag_id) VALUES (:album_id, :tag_id)");
        foreach ($album['tags'] as $tagId) {
            $tagStmt->execute([':album_id' => $id, ':tag_id' => $tagId]);
        }
    }
}



    public static function deleteAlbum(int $id)
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("DELETE FROM albums WHERE id = :id");
        $stmt->execute([':id' => $id]);

    }

    public static function getRecentAlbums($limit = 3) {
        $pdo = Database::getConnection();

        $stmt = $pdo->prepare("
            SELECT a.id, a.titre, a.image, a.duree, a.auteur, a.date,
                a.extrait, a.note,
                t.id AS tag_id, t.tag AS tag_nom
            FROM albums a
            LEFT JOIN albums_tags at ON a.id = at.album_id
            LEFT JOIN tags t ON at.tag_id = t.id
            ORDER BY a.date DESC, a.id DESC
            LIMIT :limit
        ");

        $stmt->bindValue(':limit', (int)$limit, PDO::PARAM_INT);
        $stmt->execute();

        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

        $albums = [];

        foreach ($rows as $row) {
            $id = $row['id'];

            if (!isset($albums[$id])) {
                $albums[$id] = [
                    'id'      => $row['id'],
                    'titre'   => $row['titre'],
                    'image'   => $row['image'],
                    'duree'   => $row['duree'],
                    'auteur'  => $row['auteur'],
                    'date'    => $row['date'],
                    'extrait' => $row['extrait'],
                    'note'    => $row['note'],
                    'tags'    => []
                ];
            }

            if ($row['tag_id'] !== null) {
                $albums[$id]['tags'][] = [
                    'id'  => $row['tag_id'],
                    'nom' => $row['tag_nom']
                ];
            }
        }

        return array_values($albums);
    }



public static function getAllTags(): array {
    $pdo = Database::getConnection();
    $stmt = $pdo->query("SELECT id, tag FROM tags ORDER BY tag ASC");
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

public static function getTagsByAlbumId(int $albumId): array {
    $pdo = Database::getConnection();
    $stmt = $pdo->prepare("SELECT tag_id FROM albums_tags WHERE album_id = :id");
    $stmt->execute([':id' => $albumId]);
    return $stmt->fetchAll(PDO::FETCH_COLUMN);
}
public static function deleteTagsByAlbumId(int $albumId): array {
    $pdo = Database::getConnection();
    $stmt = $pdo->prepare("DELETE FROM albums_tags WHERE album_id = :id");
    $stmt->execute([':id' => $albumId]);
    return $stmt->fetchAll(PDO::FETCH_COLUMN);
}

}
