<?php
require_once '/var/www/www.grooveguild.lol/doc/prototype/DAO/AlbumDAO.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$album = $id > 0 ? AlbumDAO::getSongById($id) : null;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $id > 0) {
    // Use absolute paths from project root
    $baseDir       = "/var/www/www.grooveguild.lol/doc/";
    $uploadDirImg  = $baseDir . "images/";
    $uploadDirAudio= $baseDir . "prototype/snippets/";

    if (!is_dir($uploadDirImg))   mkdir($uploadDirImg, 0777, true);
    if (!is_dir($uploadDirAudio)) mkdir($uploadDirAudio, 0777, true);

    $imagePath = $album['image']   ?? null;
    $audioPath = $album['extrait'] ?? null;

    if (!empty($_FILES['image']['name'])) {
        $imageFile = basename($_FILES['image']['name']);
        $imagePath = "images/" . $imageFile; // relative for DB
        move_uploaded_file($_FILES['image']['tmp_name'], $uploadDirImg . $imageFile);
    }
    if (!empty($_FILES['audio']['name'])) {
        $audioFile = basename($_FILES['audio']['name']);
        $audioPath = "snippets/" . $audioFile; // relative for DB
        move_uploaded_file($_FILES['audio']['tmp_name'], $uploadDirAudio . $audioFile);
    }

    $updatedAlbum = [
        'titre'   => $_POST['titre'] ?? '',
        'image'   => $imagePath,
        'duree'   => $album['duree'] ?? null,
        'auteur'  => $_POST['auteur'] ?? '',
        'date'    => $_POST['date'] ?? null,
        'extrait' => $audioPath,
        'note'    => $album['note'] ?? null,
    ];

    AlbumDAO::updateAlbum($id, $updatedAlbum);
    header("Location: ../administration/administration.php");
    exit;
}

?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Groove Guild – Admin / Modifier</title>
    <link rel="stylesheet" href="css/style-modif-admin.css">
</head>
<body>
<header>
    <?php include "/var/www/www.grooveguild.lol/doc/prototype/navbar/nav-bar.html"; ?>
  </header>

<main class="wrap">
    <section class="panel">
        <h1>Modifier</h1>
        <?php if ($album): ?>
        <form action="" method="post" enctype="multipart/form-data">
            <div class="field">
                <label for="titre">Titre</label>
                <input id="titre" name="titre" type="text" value="<?= htmlspecialchars($album['titre']) ?>" required>
            </div>

            <div class="row-2">
                <div class="field">
                    <label for="auteur">Auteur</label>
                    <input id="auteur" name="auteur" type="text" value="<?= htmlspecialchars($album['auteur']) ?>">
                </div>
                <div class="field">
                    <label for="date">Date</label>
                    <input id="date" name="date" type="date" value="<?= htmlspecialchars($album['date']) ?>">
                </div>
            </div>

            <div class="row-2">
            <!--
                <div class="field">
                    <label for="genre">Tags</label>
                    <input id="genre" name="genre" type="text" value="<?= htmlspecialchars(is_array($album['tags']) ? implode(',', $album['tags']) : $album['tags']) ?>">
                </div>
                -->
                <div class="field">
                    <label for="note">Note (1–5)</label>
                    <div class="range-wrap" style="display:flex;align-items:center;gap:12px;">
                        <input
                            type="range"
                            id="note"
                            name="note"
                            min="1"
                            max="5"
                            step="1"
                            value="3"
                            aria-label="Note entre 1 et 5">
                    </div>
                </div>
            </div>

            <div class="field">
                <label>Image actuelle</label><br>
                <?php if (!empty($album['image'])): ?>
                    <img src="<?= htmlspecialchars($album['image']) ?>" alt="Image" style="max-height:100px">
                <?php endif; ?>
                <input id="image" name="image" type="file" accept="image/*">
            </div>

            <div class="field">
                <label>MP3 actuel</label><br>
                <?php if (!empty($album['extrait'])): ?>
                    <audio controls src="<?= htmlspecialchars($album['extrait']) ?>"></audio>
                <?php endif; ?>
                <input id="audio" name="audio" type="file" accept="audio/mpeg">
            </div>

            <div class="actions">
                <button class="btn" type="submit">Enregistrer les modifications</button>
            </div>
            <div class="actions">
                <button class="btn" type="button" onclick="window.location.href='../administration/administration.php'">Annuler</button>
            </div>
        </form>
        <?php else: ?>
            <p>Aucun album trouvé pour l’ID fourni.</p>
        <?php endif; ?>
    </section>
</main>

<footer>
    <iframe src="../footer/footer.html" style="width:100%; border:none;" scrolling="no"></iframe>
</footer>
</body>
</html>
