<?php
require_once '/var/www/www.grooveguild.lol/doc/prototype/DAO/AlbumDAO.php';

try {
    $albums = AlbumDAO::getAllAlbums();
    $tags = AlbumDAO::getAllTags();
} catch (Exception $e) {
    die("Erreur lors de la récupération des albums : " . $e->getMessage());
}

?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Groove Guild – Liste</title>
  <link rel="stylesheet" href="css/liste.css" />
</head>
<body>
<header>
    <?php include "/var/www/www.grooveguild.lol/doc/prototype/navbar/nav-bar.html"; ?>
</header>


<main class="container">

  <!-- Section Albums -->
  <section class="panel">
    <?php foreach ($albums as $album): ?>
      <article class="album">
        <h3 class="album-title"><?= htmlspecialchars($album["titre"]) ?></h3>
        
        <div class="controls">
          <?php if (!empty($album["extrait"])): ?>
            <audio controls>
              <source src="../<?= htmlspecialchars($album["extrait"]) ?>" type="audio/mpeg">
              Votre navigateur ne supporte pas l’audio.
            </audio>
          <?php else: ?>
            <button class="btn" type="button">Échantillon non disponible</button>
          <?php endif; ?>
        </div>

        <p class="album-desc">
          Auteur: <?= htmlspecialchars($album["auteur"]) ?><br>
          Sortie: <?= htmlspecialchars($album["date"]) ?><br>
          Durée: <?= htmlspecialchars($album["duree"]) ?>
        </p>

        <?php if (!empty($album["image"])): ?>
          <div class="picture">
            <img src="/doc/<?= htmlspecialchars($album["image"]) ?>" alt="Image de l'album">
          </div>
        <?php endif; ?>

        <div class="meta">
          <div class="tags">
                    <?php foreach ($album["tags"] as $tag): ?>
                        <span class="tag"><?= htmlspecialchars($tag["nom"]) ?></span>
                    <?php endforeach; ?>
                </div>
          <div class="rating">
          <?php
                    $html = '<div class="rating" aria-label="Rate this article">' . PHP_EOL;
                    for ($i = 1; $i <= 5; $i++) {
                        if ($i <= $album["note"]) {
                            $html .= '    <span class="star filled">★</span>' . PHP_EOL;
                        } else {
                            $html .= '    <span class="star">★</span>' . PHP_EOL;
                        }
                    }
                    $html .= '</div>' . PHP_EOL;
                    echo $html
                ?>
               

        </div>

        

        <div class="detail">
          <a href="../detail/detail.php?id=<?= $album["id"] ?>" class="btn-detail">Détail</a>
        </div>
      </article>
    <?php endforeach; ?>
  </section>

  <footer>
    <iframe src="../footer/footer.html" style="width:100%; border:none;" scrolling="no"></iframe>
</footer>
</main>
</body>
</html>
