<?php

class Album
{
	private array $raw = [];
	private array $erreurs = [];

	public function getErreurs(): array { return $this->erreurs; }

	public function hasErreurs(): bool { return !empty($this->erreurs); }

	private function addErr(string $champ, string $msg): void { $this->erreurs[$champ][] = $msg; }

	private function containsMarkup(?string $s): bool {
		if ($s === null) return false;
		$decoded = html_entity_decode($s, ENT_QUOTES | ENT_HTML5, 'UTF-8');
		if ($decoded !== strip_tags($decoded)) return true;                 // balises
		if (preg_match('/<\s*script\b/i', $decoded)) return true;           // <script
		if (preg_match('/on\w+\s*=\s*/i', $decoded)) return true;           // onload=, onclick=, 
		return false;
	}
	private function okTexteSimple(?string $s): bool {
		if ($s === null) return true;
		$s = trim($s);
		if ($s === '') return true;
		return (bool)preg_match("/^[A-Za-z0-9\s'&\.,:!\?\-\(\)]+$/", $s);
	}
	/*
	// fonction de time pour quand on est sur
	private function normTime(?string $val): ?string {
		if ($val === null) return null;
		$val = trim($val);
		if ($val === '') return null;
		$p = explode(':', $val);
		if (count($p) === 2) return sprintf('%02d:%02d:00', (int)$p[0], (int)$p[1]);     // mm:ss
		if (count($p) === 3) return sprintf('%02d:%02d:%02d', (int)$p[0], (int)$p[1], (int)$p[2]); // hh:mm:ss
		return null;
	}
	*/
	private function valider(): void {
		$titre  = (string)($this->titre  ?? '');
		$auteur = (string)($this->auteur ?? '');

		foreach (['titre','auteur'] as $champ) {
			$raw = $this->raw[$champ] ?? null;
			if (is_string($raw) && $this->containsMarkup($raw)) {
				$this->addErr($champ, 'Le champ "' . $champ . '" ne doit pas contenir de HTML/JS.');
			}
		}

		if ($titre === '' || mb_strlen($titre, 'UTF-8') > 255) {
			$this->addErr('titre', 'Titre requis (<= 255 caracteres).');
		}
		if ($auteur === '' || mb_strlen($auteur, 'UTF-8') > 255) {
			$this->addErr('auteur', 'Auteur requis (<= 255 caracteres).');
		}

		if ($titre !== ''  && !$this->okTexteSimple($titre))  {
			$this->addErr('titre', 'Caracteres non autorises dans le titre.');
		}
		if ($auteur !== '' && !$this->okTexteSimple($auteur)) {
			$this->addErr('auteur', 'Caracteres non autorises dans l auteur.');
		}

		if (!empty($this->date_sortie)) {
			$d = \DateTime::createFromFormat('Y-m-d', $this->date_sortie);
			$ok = $d && $d->format('Y-m-d') === $this->date_sortie;
			if (!$ok) $this->addErr('date', 'Date invalide (format attendu: YYYY-MM-DD).');
		}
	}
	public static $filtres =
		array(
			'id' => FILTER_VALIDATE_INT,
			'titre' => FILTER_SANITIZE_STRING,
			'auteur' => FILTER_SANITIZE_STRING,
			'date_sortie' => FILTER_UNSAFE_RAW,
			'duree' => FILTER_SANITIZE_STRING,
			'image' => FILTER_SANITIZE_URL,
            'extrait' => FILTER_SANITIZE_URL,
            'tags' => FILTER_SANITIZE_STRING,
            'note' => FILTER_VALIDATE_INT,
		);

	protected $id;
	protected $titre;
	protected $auteur;
	protected $date_sortie;
	protected $duree;
    protected $image;
	protected $extrait;
	protected $tags;
    protected $note;

	public function __construct(array $tableau = [])
	{
		$this->raw = $tableau;


		$clean = filter_var_array($tableau, self::$filtres) ?: [];

		$this->id          = isset($clean['id']) ? (int)$clean['id'] : null;
		$this->titre       = isset($clean['titre']) ? trim((string)$clean['titre']) : '';
		$this->auteur      = isset($clean['auteur']) ? trim((string)$clean['auteur']) : '';
		$this->date_sortie = ($clean['date_sortie'] ?? '') !== '' ? $clean['date_sortie'] : null;
		$this->duree       = ($clean['duree'] ?? '') !== '' ? $clean['duree'] : null;
		$this->image       = $clean['image']   ?? null;
		$this->extrait     = $clean['extrait'] ?? null;
		$this->tags        = isset($clean['tags']) ? (string)$clean['tags'] : '';
		$this->note        = ($clean['note'] === false ? null : $clean['note']); 

		$this->valider();
	}
	public function __set($propriete, $valeur)
	{
		switch($propriete)
		{
			case 'id':
				$this->id = $valeur;
			break;
			case 'titre':
				$this->titre = $valeur;
			break;
			case 'auteur':
				$this->auteur = $valeur;
			break;
            case 'date_sortie':
				$this->date_sortie = $valeur;
			break;
            case 'duree':
				$this->duree = $valeur;
			break;
            case 'image':
				$this->image = $valeur;
			break;
            case 'extrait':
				$this->extrait = $valeur;
			break;
            case 'tags':
				$this->tags = $valeur;
			break;
            case 'note':
				$this->note = $valeur;
			break;
		}
	}

	public function __get($propriete)
	{
		//$variable = '$this->'.$propriete;
		//return $$variable;
		$self = get_object_vars($this); // externaliser pour optimiser
		//print_r($self);
		return $self[$propriete];
	}
}
?>
